import { Music2, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Music2 size={32} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">DanceStudio</h2>
            </div>
            <p className="footer-description">
              Элегантные танцевальные занятия для всех уровней подготовки.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@dancestudio.ru">info@dancestudio.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Танцевальная, д. 12</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Стили танцев</h3>
            <ul className="footer-links">
              <li><a href="#">Хип-хоп</a></li>
              <li><a href="#">Бачата</a></li>
              <li><a href="#">Зумба</a></li>
              <li><a href="#">Бальные</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={18} strokeWidth={2} />
                <span>Пн-Вс: 10:00 - 22:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 DanceStudio. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

